###############################################################################
#
#--------------------------------------------------------------------------
#
# MAKE file for the PMSPY's DLL
#
#--------------------------------------------------------------------------
#
# External Requirements:
# ======================
#
# 1) ENVironment variables that MUST be correctly set
#
#    * NO drives, paths, etc are contained in this MAKE file
#
#    * Before using, the following items must be SET:
#
#      - PATH    = where the utilities "live"       [C, LINK, etc]
#
#      - INCLUDE = all paths to look for #include's [C]
#      - TMP     = "home" for temporary work files  [C]
#
#      - LIB     = all paths to look for LIBraries  [LINK]
#
# 2) ENVironment variables that MAY be set
#
#      - CL      = other CL options...              [C]
#
#                  *** Example: override the C PreProcessor used
#
#                      How To:  set cl=/B1 c:\ibmc2\bin\c1l.exe
#
#--------------------------------------------------------------------------
#
# External MAKE MACROs:
# =====================
#
# wantCV.....generate CODEVIEW information
#
# wantLST....generate LISTING(s)
#
# Sample Usage: make pmspydll wantCV=1
#
###############################################################################

#------------------------------------------------------------------------------
# Symbolic names for PRODuct pieces
#------------------------------------------------------------------------------

# this is where C "lives"

cPath   = c:\ibmc2
cInc    = $(cPath)\inc
cBin    = $(cPath)\bin

# this is our PRODuct ID

PROD    = PMSPYDLL

PRODVER = 2.10

PRODDEF = $(PROD).DEF
PRODDLL = $(PROD).DLL
PRODLIB = $(PROD).LIB
PRODMAP = $(PROD).MAP

PRODSRC = $(PROD).C
PRODOBJ = $(PROD).OBJ

PRODH   = PMSPY.H

#------------------------------------------------------------------------------
# These are the external interface LIBraries we require
#------------------------------------------------------------------------------

EXTERN_LIB_OS2  = os2

#------------------------------------------------------------------------------
# C parameters
#------------------------------------------------------------------------------

cWARN           = /W3
cMEM            = /Alfu
cOPTS           = /c /I $(cInc) /B1 $(cBin)\c1l.exe /G2s /Zp /Oi

# decide about listings..

!ifdef wantLST
cLST            = /Fs /St "PMSPY DLL" /Ss "Version $(PRODVER)" /Sl 132
!endif

# decide about CODEVIEW...

!ifdef wantCV
cOPTS           = $(cOPTS) /Zi /Od
!else
cOPTS           = $(cOPTS) /Ox
!endif

#------------------------------------------------------------------------------
# LINK parameters
#------------------------------------------------------------------------------

lMain           = /NOD/MAP/FARCALL

!ifdef wantCV
lMain           = $(lMain)/COD
!endif

#-------------------------------------------------------------------------------
# *** THIS is THE inference rule to generate our code.... ***
#
# the leading '-' tells MAKE to not abort on a CL error
#
#------------------------------------------------------------------------------

.c.obj:
#
  cl  $(cOPTS) $(cMEM) $(cWARN) $*.c

#-------------------------------------------------------------------------------
#
# *** THIS is THE major dependency rule...it forces anything to happen
#
#------------------------------------------------------------------------------

Dummy.Exe : $(PRODDLL) $(PRODLIB)

#-------------------------------------------------------------------------------
#
# Build our DLL
#
#------------------------------------------------------------------------------

$(PRODOBJ) : $(PRODH) $(PRODSRC)

$(PRODDLL) : $(PRODOBJ) $(PRODDEF)
  link $(lMain) @<<
$(PRODOBJ)
$(PRODDLL)
$(PRODMAP)
$(EXTERN_LIB_OS2)
$(PRODDEF)
<<

#-------------------------------------------------------------------------------
#
# Build our .LIB with external references for PMSPY.EXE
#
#------------------------------------------------------------------------------

$(PRODLIB) : $(PRODDLL)
  implib $(PRODLIB) $(PRODDEF)
